package gov.va.med.mhv.health.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;


@FacesValidator(value="MilitaryValidator")
public class MilitaryValidator implements Validator {
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String LabelField="";
		
		LabelField = component.getId();
		 if (LabelField.equalsIgnoreCase("eventTitle")){
			 LabelField = "Event Title"; 
		 }
			
		 if (LabelField.equalsIgnoreCase("exposures")){
			 LabelField = "Exposures"; 
		 }	
		 
		 if (LabelField.equalsIgnoreCase("experience")){
			 LabelField = "Experience"; 
		 }			 
		String Military = (String) value;
				
		if (Military == null || Military.isEmpty()) {
			return; // Let required="true" or @NotNull handle it.
		}
		
		if (Military.length() < 2) {
			String summary = String.format("The %s value must be at least 2 characters long.", LabelField);
			String detail = "Enter a value that is at least 2 characters long.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}

}
